using System;
using System.Collections.Generic;

public class ClockEventArgs : EventArgs
{
    private DateTime m_time;

	public DateTime Time
	{
		get { return m_time;}
		set { m_time = value;}
	}
}

public class Clock
{
    public event EventHandler<ClockEventArgs> Tick;

    public void RaiseTick()
    {
        if (Tick != null)
        {
            ClockEventArgs arg = new ClockEventArgs();
            arg.Time = DateTime.Now;

            Tick(this, arg);
        }
    }
}

public class Alarm
{
    public void ListenToTick(object sender, ClockEventArgs e)
    {
        Console.WriteLine("Najwyszy czas na dzwonek!");
    }
}
